/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.RepeaterEvent;
import org.apache.cocoon.forms.event.RepeaterListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractContainerDefinition;
import org.apache.cocoon.forms.formmodel.EnhancedRepeater;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class RepeaterDefinition
extends AbstractContainerDefinition {
    private int initialSize = 0;
    private int minSize;
    private int maxSize;
    private boolean orderable;
    private RepeaterListener listener;
    private boolean enhanced = false;
    private int initialPage = 0;
    private int pageSize;
    private String customPageId;

    public RepeaterDefinition(int initialSize, int minSize, int maxSize, boolean selectable, boolean orderable) {
        this.initialSize = initialSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.orderable = orderable;
    }

    public RepeaterDefinition(int initialSize, int minSize, int maxSize, boolean selectable, boolean orderable, boolean enhanced, int initialPage, int pageSize, String customPageId) {
        this.initialSize = initialSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.orderable = orderable;
        this.enhanced = enhanced;
        this.initialPage = initialPage;
        this.pageSize = pageSize;
        this.customPageId = customPageId;
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof RepeaterDefinition)) {
            throw new FormsException("Parent definition " + definition.getClass().getName() + " is not a RepeaterDefinition.", this.getLocation());
        }
        RepeaterDefinition other = (RepeaterDefinition)definition;
        this.initialSize = other.initialSize;
        this.maxSize = other.maxSize;
        this.minSize = other.minSize;
        this.enhanced = other.enhanced;
        this.orderable = other.orderable;
        this.initialPage = other.initialPage;
        this.pageSize = other.pageSize;
    }

    public Widget createInstance() {
        if (this.enhanced) {
            return new EnhancedRepeater(this);
        }
        return new Repeater(this);
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public boolean getOrderable() {
        return this.orderable;
    }

    public void addRepeaterListener(RepeaterListener listener) {
        this.checkMutable();
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void fireRepeaterEvent(RepeaterEvent event) {
        if (this.listener != null) {
            this.listener.repeaterModified(event);
        }
    }

    public boolean hasRepeaterListeners() {
        return this.listener != null;
    }

    public RepeaterListener getRepeaterListener() {
        return this.listener;
    }

    public int getInitialPage() {
        return this.initialPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    public String getCustomPageId() {
        return this.customPageId;
    }
}

