/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.RepeaterActionDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.Deprecation;
import org.w3c.dom.Element;

public class RepeaterActionDefinitionBuilder
extends AbstractWidgetDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        String actionCommand = DomHelper.getAttribute(widgetElement, "command", null);
        if (actionCommand == null && (actionCommand = DomHelper.getAttribute(widgetElement, "action-command", null)) != null) {
            Deprecation.logger.info((Object)("The 'action-command' attribute is deprecated and replaced by 'command', at " + DomHelper.getLocation(widgetElement)));
        }
        if (actionCommand == null) {
            throw new FormsException("Required attribute 'command' is missing.", DomHelper.getLocationObject(widgetElement));
        }
        RepeaterActionDefinition definition = this.createDefinition(widgetElement, actionCommand);
        this.setupDefinition(widgetElement, definition, context);
        this.setDisplayData(widgetElement, definition);
        definition.setActionCommand(actionCommand);
        Element buggyOnActivate = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "on-activate", false);
        if (buggyOnActivate != null) {
            throw new FormsException("Use 'on-action' instead of 'on-activate' on row-action.", DomHelper.getLocationObject(buggyOnActivate));
        }
        Iterator i = this.buildEventListeners(widgetElement, "on-action", ActionListener.class).iterator();
        while (i.hasNext()) {
            definition.addActionListener((ActionListener)i.next());
        }
        definition.makeImmutable();
        return definition;
    }

    protected RepeaterActionDefinition createDefinition(Element element, String actionCommand) throws Exception {
        String repeater = DomHelper.getAttribute(element, "repeater");
        if ("delete-rows".equals(actionCommand)) {
            String select = DomHelper.getAttribute(element, "select");
            return new RepeaterActionDefinition.DeleteRowsActionDefinition(repeater, select);
        }
        if ("add-row".equals(actionCommand)) {
            int insertRows = DomHelper.getAttributeAsInteger(element, "number-of-rows", 1);
            return new RepeaterActionDefinition.AddRowActionDefinition(repeater, insertRows);
        }
        if ("insert-rows".equals(actionCommand)) {
            String select = DomHelper.getAttribute(element, "select");
            return new RepeaterActionDefinition.InsertRowsActionDefinition(repeater, select);
        }
        if ("sort-by".equals(actionCommand)) {
            String field = DomHelper.getAttribute(element, "field", null);
            return new RepeaterActionDefinition.SortActionDefinition(repeater, field);
        }
        if ("page-first".equals(actionCommand)) {
            return new RepeaterActionDefinition.ChangePageActionDefinition(repeater, 0);
        }
        if ("page-prev".equals(actionCommand)) {
            return new RepeaterActionDefinition.ChangePageActionDefinition(repeater, 1);
        }
        if ("page-next".equals(actionCommand)) {
            return new RepeaterActionDefinition.ChangePageActionDefinition(repeater, 2);
        }
        if ("page-last".equals(actionCommand)) {
            return new RepeaterActionDefinition.ChangePageActionDefinition(repeater, 3);
        }
        if ("page-custom".equals(actionCommand)) {
            return new RepeaterActionDefinition.ChangePageActionDefinition(repeater, 4);
        }
        throw new FormsException("Unknown repeater action '" + actionCommand + "'.", DomHelper.getLocationObject(element));
    }
}

