/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.FormsRuntimeException;
import org.apache.cocoon.forms.event.RepeaterEvent;
import org.apache.cocoon.forms.event.RepeaterEventAction;
import org.apache.cocoon.forms.event.RepeaterListener;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractContainerWidget;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.RepeaterDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Repeater
extends AbstractWidget
implements ValidationErrorAware {
    private static final String REPEATER_EL = "repeater";
    private static final String HEADINGS_EL = "headings";
    private static final String HEADING_EL = "heading";
    private static final String LABEL_EL = "label";
    private static final String REPEATER_SIZE_EL = "repeater-size";
    protected final RepeaterDefinition definition;
    protected final List rows = new ArrayList();
    protected ValidationError validationError;
    private boolean orderable = false;
    private RepeaterListener listener;

    public Repeater(RepeaterDefinition repeaterDefinition) {
        super(repeaterDefinition);
        this.definition = repeaterDefinition;
        for (int i = 0; i < this.definition.getInitialSize(); ++i) {
            this.rows.add(new RepeaterRow(this.definition));
        }
        this.orderable = this.definition.getOrderable();
        this.listener = this.definition.getRepeaterListener();
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void initialize() {
        for (int i = 0; i < this.rows.size(); ++i) {
            ((RepeaterRow)this.rows.get(i)).initialize();
            this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROW_ADDED, i));
        }
        super.initialize();
    }

    public int getSize() {
        return this.rows.size();
    }

    public int getMinSize() {
        return this.definition.getMinSize();
    }

    public int getMaxSize() {
        return this.definition.getMaxSize();
    }

    public RepeaterRow addRow() {
        RepeaterRow repeaterRow = new RepeaterRow(this.definition);
        this.rows.add(repeaterRow);
        repeaterRow.initialize();
        this.getForm().addWidgetUpdate(this);
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROW_ADDED, this.rows.size() - 1));
        return repeaterRow;
    }

    public RepeaterRow addRow(int index) {
        RepeaterRow repeaterRow = new RepeaterRow(this.definition);
        if (index >= this.rows.size()) {
            this.rows.add(repeaterRow);
            index = this.rows.size() - 1;
        } else {
            this.rows.add(index, repeaterRow);
        }
        repeaterRow.initialize();
        this.getForm().addWidgetUpdate(this);
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROW_ADDED, index));
        return repeaterRow;
    }

    public RepeaterRow getRow(int index) {
        return (RepeaterRow)this.rows.get(index);
    }

    public Widget getChild(String id) {
        int rowIndex;
        try {
            rowIndex = Integer.parseInt(id);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this.getSize()) {
            return null;
        }
        return this.getRow(rowIndex);
    }

    public static RepeaterRow getParentRow(Widget widget) {
        Widget result;
        for (result = widget; result != null && !(result instanceof RepeaterRow); result = result.getParent()) {
        }
        if (result == null) {
            throw new RuntimeException("Could not find a parent row for widget " + widget);
        }
        return (RepeaterRow)result;
    }

    public int indexOf(RepeaterRow row) {
        return this.rows.indexOf(row);
    }

    public void removeRow(int index) {
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROW_DELETING, index));
        this.rows.remove(index);
        this.getForm().addWidgetUpdate(this);
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROW_DELETED, index));
    }

    public void moveRow(int from, int to) {
        int size = this.rows.size();
        if (from < 0 || from >= size || to < 0 || to > size) {
            throw new IllegalArgumentException("Cannot move from " + from + " to " + to + " on repeater with " + size + " rows");
        }
        if (from == to) {
            return;
        }
        Object fromRow = this.rows.remove(from);
        if (to == size) {
            this.rows.add(fromRow);
        } else if (to > from) {
            this.rows.add(to - 1, fromRow);
        } else {
            this.rows.add(to, fromRow);
        }
        this.getForm().addWidgetUpdate(this);
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROWS_REARRANGED));
    }

    public void moveRow2(int from, int to) {
        int size = this.rows.size();
        if (from < 0 || from >= size || to < 0 || to >= size) {
            throw new IllegalArgumentException("Cannot move from " + from + " to " + to + " on repeater with " + size + " rows");
        }
        if (from == to) {
            return;
        }
        Object fromRow = this.rows.remove(from);
        this.rows.add(to, fromRow);
        this.getForm().addWidgetUpdate(this);
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROWS_REARRANGED));
    }

    public void moveRowLeft(int index) {
        if (index != 0 && index < this.rows.size()) {
            Object temp = this.rows.get(index - 1);
            this.rows.set(index - 1, this.rows.get(index));
            this.rows.set(index, temp);
        }
        this.getForm().addWidgetUpdate(this);
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROWS_REARRANGED));
    }

    public void moveRowRight(int index) {
        if (index >= 0 && index < this.rows.size() - 1) {
            Object temp = this.rows.get(index + 1);
            this.rows.set(index + 1, this.rows.get(index));
            this.rows.set(index, temp);
        }
        this.getForm().addWidgetUpdate(this);
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROWS_REARRANGED));
    }

    public void removeRows() {
        this.clear();
    }

    public void clear() {
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROWS_CLEARING));
        this.rows.clear();
        this.broadcastEvent(new RepeaterEvent(this, RepeaterEventAction.ROWS_CLEARED));
        for (int i = 0; i < this.definition.getInitialSize(); ++i) {
            this.addRow();
        }
        this.getForm().addWidgetUpdate(this);
    }

    public void addRepeaterListener(RepeaterListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeRepeaterListener(RepeaterListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    public boolean hasRepeaterListeners() {
        return this.listener != null;
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof RepeaterEvent) {
            if (this.listener != null) {
                this.listener.repeaterModified((RepeaterEvent)event);
            }
        } else {
            super.broadcastEvent(event);
        }
    }

    public Widget getWidget(int rowIndex, String id) {
        RepeaterRow row = (RepeaterRow)this.rows.get(rowIndex);
        return row.getChild(id);
    }

    public void readFromRequest(FormContext formContext) {
        int from;
        String paramName;
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        Request req = formContext.getRequest();
        String sizeParameter = req.getParameter((paramName = this.getRequestParameterName()) + ".size");
        if (sizeParameter != null) {
            int i;
            int size = 0;
            try {
                size = Integer.parseInt(sizeParameter);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (size > 500) {
                throw new RuntimeException("Client is not allowed to specify a repeater size larger than 500.");
            }
            int currentSize = this.getSize();
            if (currentSize < size) {
                for (i = currentSize; i < size; ++i) {
                    this.addRow();
                }
            } else if (currentSize > size) {
                for (i = currentSize - 1; i >= size; --i) {
                    this.removeRow(i);
                }
            }
        }
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            RepeaterRow row = (RepeaterRow)rowIt.next();
            row.readFromRequest(formContext);
        }
        String action = req.getParameter(paramName + ".action");
        if (action == null) {
            return;
        }
        if (action.equals("move")) {
            if (!this.orderable) {
                throw new FormsRuntimeException("Widget " + this + " is not orderable", this.getLocation());
            }
            from = Integer.parseInt(req.getParameter(paramName + ".from"));
            int before = Integer.parseInt(req.getParameter(paramName + ".before"));
            Object row = this.rows.get(from);
            this.rows.add(before, row);
            if (before < from) {
                ++from;
            }
        } else {
            throw new FormsRuntimeException("Unknown action " + action + " for " + this, this.getLocation());
        }
        this.rows.remove(from);
        this.getForm().addWidgetUpdate(this);
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        boolean valid = true;
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            RepeaterRow row = (RepeaterRow)rowIt.next();
            valid &= row.validate();
        }
        if (this.rows.size() > this.getMaxSize() || this.rows.size() < this.getMinSize()) {
            String[] boundaries = new String[]{String.valueOf(this.getMinSize()), String.valueOf(this.getMaxSize())};
            this.validationError = new ValidationError(new I18nMessage("repeater.cardinality", boundaries, "forms"));
            valid = false;
        }
        if (valid) {
            valid = super.validate();
        }
        this.wasValid = valid && this.validationError == null;
        return this.wasValid;
    }

    public String getXMLElementName() {
        return REPEATER_EL;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("size", String.valueOf(this.getSize()));
        int size = this.getMinSize();
        if (size > 0) {
            attrs.addCDATAAttribute("min-size", String.valueOf(size));
        }
        if ((size = this.getMaxSize()) != Integer.MAX_VALUE) {
            attrs.addCDATAAttribute("max-size", String.valueOf(size));
        }
        return attrs;
    }

    public void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", LABEL_EL, "fi:label", XMLUtils.EMPTY_ATTRIBUTES);
        this.generateLabel(contentHandler);
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", LABEL_EL, "fi:label");
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", HEADINGS_EL, "fi:headings", XMLUtils.EMPTY_ATTRIBUTES);
        Iterator widgetDefinitionIt = this.definition.getWidgetDefinitions().iterator();
        while (widgetDefinitionIt.hasNext()) {
            WidgetDefinition widgetDefinition = (WidgetDefinition)widgetDefinitionIt.next();
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", HEADING_EL, "fi:heading", XMLUtils.EMPTY_ATTRIBUTES);
            widgetDefinition.generateLabel(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", HEADING_EL, "fi:heading");
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", HEADINGS_EL, "fi:headings");
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            RepeaterRow row = (RepeaterRow)rowIt.next();
            row.generateSaxFragment(contentHandler, locale);
        }
    }

    public void generateWidgetLabel(String widgetId, ContentHandler contentHandler) throws SAXException {
        WidgetDefinition widgetDefinition = this.definition.getWidgetDefinition(widgetId);
        if (widgetDefinition == null) {
            throw new SAXException("Repeater '" + this.getRequestParameterName() + "' at " + this.getLocation() + " contains no widget with id '" + widgetId + "'.");
        }
        widgetDefinition.generateLabel(contentHandler);
    }

    public void generateSize(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attrs = this.getXMLElementAttributes();
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", REPEATER_SIZE_EL, "fi:repeater-size", (Attributes)attrs);
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", REPEATER_SIZE_EL, "fi:repeater-size");
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
    }

    public class RepeaterRow
    extends AbstractContainerWidget {
        private static final String ROW_EL = "repeater-row";
        private int cachedPosition;
        private String cachedId;

        public RepeaterRow(RepeaterDefinition definition) {
            super(definition);
            this.cachedPosition = -100;
            this.cachedId = "--undefined--";
            this.setParent(Repeater.this);
            definition.createWidgets(this);
        }

        public WidgetDefinition getDefinition() {
            return Repeater.this.getDefinition();
        }

        public String getId() {
            int pos = Repeater.this.rows.indexOf(this);
            if (pos == -1) {
                throw new IllegalStateException("Row has currently no position");
            }
            if (pos != this.cachedPosition) {
                this.cachedPosition = pos;
                this.cachedId = String.valueOf(pos);
                this.widgetNameChanged();
            }
            return this.cachedId;
        }

        public String getRequestParameterName() {
            this.getId();
            return super.getRequestParameterName();
        }

        public Form getForm() {
            return Repeater.this.getForm();
        }

        public void initialize() {
            Iterator i = this.getChildren();
            while (i.hasNext()) {
                ((Widget)i.next()).initialize();
            }
        }

        public boolean validate() {
            return this.widgets.validate();
        }

        public String getXMLElementName() {
            return ROW_EL;
        }

        public void generateLabel(ContentHandler contentHandler) throws SAXException {
        }

        public void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        }

        public void broadcastEvent(WidgetEvent event) {
            throw new UnsupportedOperationException("Widget " + this + " doesn't handle events.");
        }
    }
}

