/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.RepeaterItem;
import org.apache.cocoon.forms.binding.RepeaterJXPathCollection;
import org.apache.cocoon.forms.datatype.StaticSelectionList;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.RepeaterDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.xml.AttributesImpl;

public class EnhancedRepeater
extends Repeater {
    private RepeaterJXPathCollection collection;
    private String customPageFieldId;
    private Field customPageField;
    private int currentPage;
    private int pageSize;

    public EnhancedRepeater(RepeaterDefinition repeaterDefinition) {
        super(repeaterDefinition);
        this.currentPage = this.definition.getInitialPage();
        this.pageSize = this.definition.getPageSize();
        this.customPageFieldId = this.definition.getCustomPageId();
    }

    public void doPageLoad() throws BindingException {
        RepeaterItem item;
        this.clearAllRows();
        this.collection.flushCachedItems();
        int start = this.getStartIndex();
        List items = this.collection.getItems(start, this.pageSize);
        Iterator iter = items.iterator();
        while (iter.hasNext() && (item = (RepeaterItem)iter.next()) != null) {
            if (item.getRow() != null) {
                this.addRow(item.getRow());
                continue;
            }
            Repeater.RepeaterRow thisRow = this.addRow();
            item.setRow(thisRow);
            this.collection.getAdapter().populateRow(item);
        }
        if (this.customPageField != null) {
            StaticSelectionList selectionList = new StaticSelectionList(this.customPageField.getDatatype());
            for (int j = 0; j <= this.getMaxPage(); ++j) {
                selectionList.addItem((Object)new Integer(j), j + 1 + "");
            }
            this.customPageField.setSelectionList(selectionList);
            this.customPageField.setValue(new Integer(this.currentPage));
        }
    }

    public void doPageSave() throws BindingException {
        RepeaterItem item;
        ArrayList<RepeaterItem> tempUpdatedRows = new ArrayList<RepeaterItem>();
        ArrayList<Repeater.RepeaterRow> tempInsertedRows = new ArrayList<Repeater.RepeaterRow>();
        List cache = this.collection.getCachedItems();
        int formRowCount = this.getSize();
        for (int i = 0; i < formRowCount; ++i) {
            RepeaterItem item2;
            Repeater.RepeaterRow thisRow = this.getRow(i);
            boolean found = false;
            for (int j = 0; j < cache.size() && (item2 = (RepeaterItem)cache.get(j)) != null; ++j) {
                if (item2.getRow() != thisRow) continue;
                tempUpdatedRows.add(item2);
                found = true;
                break;
            }
            if (found) continue;
            tempInsertedRows.add(thisRow);
        }
        ArrayList<RepeaterItem> toDelete = new ArrayList<RepeaterItem>();
        for (int j = 0; j < cache.size() && (item = (RepeaterItem)cache.get(j)) != null; ++j) {
            boolean found = false;
            for (int i = 0; i < formRowCount; ++i) {
                Repeater.RepeaterRow thisRow = this.getRow(i);
                if (thisRow != item.getRow()) continue;
                found = true;
                break;
            }
            if (found) continue;
            toDelete.add(item);
        }
        Iterator iter = tempUpdatedRows.iterator();
        while (iter.hasNext()) {
            RepeaterItem ele = (RepeaterItem)iter.next();
            this.collection.updateRow(ele);
        }
        iter = tempInsertedRows.iterator();
        while (iter.hasNext()) {
            Repeater.RepeaterRow row = (Repeater.RepeaterRow)iter.next();
            this.collection.addRow(row);
        }
        iter = toDelete.iterator();
        while (iter.hasNext()) {
            RepeaterItem ele = (RepeaterItem)iter.next();
            this.collection.deleteRow(ele);
        }
        this.collection.flushCachedItems();
    }

    private int getStartIndex() {
        return this.currentPage * this.pageSize;
    }

    public int getMaxPage() {
        return (int)Math.ceil((double)this.collection.getActualCollectionSize() / (double)this.pageSize) - 1;
    }

    public int getCustomPageWidgetValue() {
        return (Integer)this.customPageField.getValue();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getDisplayableCurrentPage() {
        return this.getCurrentPage() + 1;
    }

    public int getDisplayableLastPage() {
        if (this.getCurrentPage() > this.getMaxPage()) {
            return this.getMaxPage() + 2;
        }
        return this.getMaxPage() + 1;
    }

    public boolean isFirstPage() {
        return this.getCurrentPage() == 0;
    }

    public boolean isLastPage() {
        return this.getCurrentPage() >= this.getMaxPage();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isEnhanced() {
        return true;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl elementAttributes = super.getXMLElementAttributes();
        if (this.pageSize < Integer.MAX_VALUE) {
            elementAttributes.addCDATAAttribute("page", String.valueOf(this.currentPage));
        }
        return elementAttributes;
    }

    private void addRow(Repeater.RepeaterRow row) {
        this.rows.add(row);
        this.getForm().addWidgetUpdate(this);
    }

    private void clearAllRows() {
        this.rows.clear();
        this.getForm().addWidgetUpdate(this);
    }

    public void setCollection(RepeaterJXPathCollection collection) {
        this.collection = collection;
    }

    public void initialize() {
        super.initialize();
        Widget widget = this.getForm().lookupWidget(this.customPageFieldId);
        if (widget instanceof Field) {
            this.customPageField = (Field)widget;
        }
    }

    public RepeaterJXPathCollection getCollection() {
        return this.collection;
    }

    public void refreshPage() throws BindingException {
        this.doPageSave();
        this.doPageLoad();
    }

    public void goToPage(int page) throws BindingException {
        this.doPageSave();
        this.currentPage = page;
        this.doPageLoad();
    }

    public void sortBy(String field) throws BindingException {
        this.doPageSave();
        this.collection.sortBy(field);
        this.currentPage = 0;
        this.doPageLoad();
    }

    public void setFilter(String field, Object value) throws BindingException {
        this.doPageSave();
        this.collection.filter(field, value);
        this.currentPage = 0;
        this.doPageLoad();
    }
}

