/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.BooleanField;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class BooleanFieldDefinition
extends AbstractWidgetDefinition {
    private ValueChangedListener listener;
    private Boolean initialValue;
    private String trueParamValue = "true";

    public Widget createInstance() {
        return new BooleanField(this);
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof BooleanFieldDefinition)) {
            throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not a BooleanFieldDefinition.", this.getLocation());
        }
        BooleanFieldDefinition other = (BooleanFieldDefinition)definition;
        this.listener = other.listener;
        this.initialValue = other.initialValue;
        this.trueParamValue = other.trueParamValue;
    }

    public void setInitialValue(Boolean value) {
        this.checkMutable();
        this.initialValue = value;
    }

    public Boolean getInitialValue() {
        return this.initialValue;
    }

    public void setTrueParamValue(String value) {
        this.checkMutable();
        this.trueParamValue = value;
    }

    public String getTrueParamValue() {
        return this.trueParamValue;
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.checkMutable();
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public ValueChangedListener getValueChangedListener() {
        return this.listener;
    }

    public void fireValueChangedEvent(ValueChangedEvent event) {
        if (this.listener != null) {
            this.listener.valueChanged(event);
        }
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }

    public void setRequired(boolean required) {
        this.checkMutable();
        throw new UnsupportedOperationException("The property 'required' is not available on widgets of type booleanfield.");
    }
}

