/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.BooleanFieldDefinition;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.BooleanUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BooleanField
extends AbstractWidget
implements ValidationErrorAware,
ValueChangedListenerEnabled {
    private static final String BOOLEAN_FIELD_EL = "booleanfield";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";
    private Boolean value = Boolean.FALSE;
    private final BooleanFieldDefinition definition;
    private ValueChangedListener listener;
    protected ValidationError validationError;

    public BooleanField(BooleanFieldDefinition definition) {
        super(definition);
        this.definition = definition;
        this.listener = definition.getValueChangedListener();
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void initialize() {
        Boolean value = this.definition.getInitialValue();
        if (value != null) {
            this.setValue(value);
        }
        super.initialize();
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        this.validationError = null;
        Boolean oldValue = this.value;
        String param = formContext.getRequest().getParameter(this.getRequestParameterName());
        this.value = BooleanUtils.toBooleanObject((boolean)this.definition.getTrueParamValue().equals(param));
        if (!this.value.equals(oldValue)) {
            this.getForm().addWidgetEvent(new ValueChangedEvent(this, oldValue, this.value));
        }
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
        this.getForm().addWidgetUpdate(this);
    }

    public String getXMLElementName() {
        return BOOLEAN_FIELD_EL;
    }

    protected AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("true-value", this.definition.getTrueParamValue());
        return attrs;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", XMLUtils.EMPTY_ATTRIBUTES);
        String stringValue = BooleanUtils.toBoolean((Boolean)this.value) ? this.definition.getTrueParamValue() : "false";
        contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        if (this.validationError != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (object == null) {
            object = Boolean.FALSE;
        }
        if (!(object instanceof Boolean)) {
            throw new RuntimeException("Cannot set value of boolean field '" + this.getRequestParameterName() + "' to a non-Boolean value.");
        }
        Boolean oldValue = this.value;
        this.value = (Boolean)object;
        if (!this.value.equals(oldValue)) {
            Form form = this.getForm();
            if (this.hasValueChangedListeners() || this.getForm().hasFormHandler()) {
                form.addWidgetEvent(new ValueChangedEvent(this, oldValue, this.value));
            }
            form.addWidgetUpdate(this);
        }
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ValueChangedEvent) {
            if (this.listener != null) {
                this.listener.valueChanged((ValueChangedEvent)event);
            }
        } else {
            super.broadcastEvent(event);
        }
    }
}

