/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.typeimpl;

import java.util.Map;
import org.apache.cocoon.forms.datatype.DatatypeBuilder;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.ConvertorBuilder;
import org.apache.cocoon.forms.datatype.typeimpl.AbstractDatatype;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public abstract class AbstractDatatypeBuilder
implements DatatypeBuilder {
    private Map convertorBuilders;
    private String defaultConvertorName;
    private String plainConvertorName;

    public void buildConvertor(Element datatypeEl, AbstractDatatype datatype) throws Exception {
        Element convertorEl = DomHelper.getChildElement(datatypeEl, "http://apache.org/cocoon/forms/1.0#definition", "convertor", false);
        Convertor convertor = this.buildConvertor(convertorEl);
        datatype.setConvertor(convertor);
    }

    public Convertor buildConvertor(Element convertorEl) throws Exception {
        ConvertorBuilder convertorBuilder;
        String type = null;
        if (convertorEl != null) {
            type = convertorEl.getAttribute("type");
        }
        if (type == null || type.length() == 0) {
            type = this.defaultConvertorName;
        }
        if ((convertorBuilder = (ConvertorBuilder)this.convertorBuilders.get(type)) == null) {
            throw new IllegalArgumentException("Undefined ConvertorBuild: " + type);
        }
        return convertorBuilder.build(convertorEl);
    }

    public Convertor getPlainConvertor() {
        return (Convertor)this.convertorBuilders.get(this.plainConvertorName);
    }

    protected void buildValidationRules(Element datatypeElement, AbstractDatatype datatype, DatatypeManager datatypeManager) throws Exception {
        Element validationElement = DomHelper.getChildElement(datatypeElement, "http://apache.org/cocoon/forms/1.0#definition", "validation");
        if (validationElement != null) {
            Element[] validationElements = DomHelper.getChildElements(validationElement, "http://apache.org/cocoon/forms/1.0#definition");
            for (int i = 0; i < validationElements.length; ++i) {
                ValidationRule rule = datatypeManager.createValidationRule(validationElements[i]);
                if (!rule.supportsType(datatype.getTypeClass(), datatype.isArrayType())) {
                    throw new Exception("Validation rule \"" + validationElements[i].getLocalName() + "\" cannot be used with type <" + (datatype.isArrayType() ? "array of " : "") + datatype.getTypeClass().getName() + ">, error at " + DomHelper.getLocation(validationElements[i]));
                }
                datatype.addValidationRule(rule);
            }
        }
    }

    public void setConvertorBuilders(Map convertorBuilders) {
        this.convertorBuilders = convertorBuilders;
    }

    public void setDefaultConvertorName(String defaultConvertorName) {
        this.defaultConvertorName = defaultConvertorName;
    }

    public void setPlainConvertorName(String plainConvertorName) {
        this.plainConvertorName = plainConvertorName;
    }
}

