/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.LocaleMap;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Icu4jDateConvertor
implements Convertor {
    private int style = 3;
    private String variant = "date";
    private LocaleMap localizedPatterns = new LocaleMap();
    private String nonLocalizedPattern;
    private boolean lenient = true;
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String DATE_TIME = "datetime";
    private static final String CONVERTOR_EL = "convertor";

    public ConversionResult convertFromString(String value, Locale locale, Convertor.FormatCache formatCache) {
        SimpleDateFormat dateFormat = this.getDateFormat(locale, formatCache);
        try {
            return new ConversionResult(dateFormat.parse(value));
        }
        catch (ParseException e) {
            return ConversionResult.create("date." + this.variant);
        }
    }

    public String convertToString(Object value, Locale locale, Convertor.FormatCache formatCache) {
        SimpleDateFormat dateFormat = this.getDateFormat(locale, formatCache);
        return dateFormat.format((Date)value);
    }

    private final SimpleDateFormat getDateFormat(Locale locale, Convertor.FormatCache formatCache) {
        SimpleDateFormat dateFormat = null;
        if (formatCache != null) {
            dateFormat = (SimpleDateFormat)formatCache.get();
        }
        if (dateFormat == null) {
            dateFormat = this.getDateFormat(locale);
            if (formatCache != null) {
                formatCache.store(dateFormat);
            }
        }
        dateFormat.setLenient(this.lenient);
        return dateFormat;
    }

    protected SimpleDateFormat getDateFormat(Locale locale) {
        SimpleDateFormat dateFormat = null;
        if (this.variant.equals(DATE)) {
            dateFormat = (SimpleDateFormat)DateFormat.getDateInstance((int)this.style, (Locale)locale);
        } else if (this.variant.equals(TIME)) {
            dateFormat = (SimpleDateFormat)DateFormat.getTimeInstance((int)this.style, (Locale)locale);
        } else if (this.variant.equals(DATE_TIME)) {
            dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance((int)this.style, (int)this.style, (Locale)locale);
        }
        String pattern = (String)this.localizedPatterns.get(locale);
        if (pattern != null) {
            dateFormat.applyPattern(pattern);
        } else if (this.nonLocalizedPattern != null) {
            dateFormat.applyPattern(this.nonLocalizedPattern);
        }
        dateFormat.setLenient(this.lenient);
        return dateFormat;
    }

    public Class getTypeClass() {
        return Date.class;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setVariant(String variant) {
        if (!(DATE.equals(variant) || TIME.equals(variant) || DATE_TIME.equals(variant))) {
            throw new IllegalArgumentException("Invalid value for variant parameter.");
        }
        this.variant = variant;
    }

    public void addFormattingPattern(Locale locale, String pattern) {
        this.localizedPatterns.put(locale, pattern);
    }

    public void setNonLocalizedPattern(String pattern) {
        this.nonLocalizedPattern = pattern;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        String pattern = this.getDateFormat(locale).toPattern();
        if (pattern != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("pattern", pattern);
            attrs.addCDATAAttribute("variant", this.variant);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", CONVERTOR_EL, "fi:convertor", (Attributes)attrs);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", CONVERTOR_EL, "fi:convertor");
        }
    }
}

