/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EnumConvertor
implements Convertor {
    private Class clazz;

    public EnumConvertor(String className) {
        try {
            this.clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + className + " not found", e);
        }
    }

    public ConversionResult convertFromString(String value, Locale locale, Convertor.FormatCache formatCache) {
        try {
            try {
                Method method = this.getTypeClass().getMethod("fromString", String.class, Locale.class);
                return new ConversionResult(method.invoke(null, value, locale));
            }
            catch (NoSuchMethodException nsme) {
                int pos = value.lastIndexOf(46);
                if (pos >= 0) {
                    value = value.substring(pos + 1);
                }
                Class clazz = this.getTypeClass();
                Field field = clazz.getField(value);
                return new ConversionResult(field.get(null));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Got exception trying to convert " + value, e);
        }
    }

    public String convertToString(Object value, Locale locale, Convertor.FormatCache formatCache) {
        Class clazz = this.getTypeClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                int mods = fields[i].getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || !fields[i].get(null).equals(value)) continue;
                return clazz.getName() + "." + fields[i].getName();
            }
            catch (Exception e) {
                throw new RuntimeException("Got exception trying to get value of field " + fields[i], e);
            }
        }
        return value.toString();
    }

    public Class getTypeClass() {
        return this.clazz;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
    }
}

