/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.JavaSelectionList;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.SelectionListBuilder;
import org.apache.cocoon.forms.datatype.StaticSelectionList;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JavaSelectionListBuilder
implements SelectionListBuilder,
BeanFactoryAware {
    private static Log LOG = LogFactory.getLog((Class)JavaSelectionListBuilder.class);
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public SelectionList build(Element selectionListElement, Datatype datatype) throws Exception {
        if (DomHelper.getAttribute(selectionListElement, "class", null) != null) {
            throw new RuntimeException("The 'class' attribute is not supported anymore at " + DomHelper.getLocationObject(selectionListElement) + ". Use a 'ref' attribute to address a Spring bean");
        }
        String beanRef = DomHelper.getAttribute(selectionListElement, "ref");
        boolean nullable = DomHelper.getAttributeAsBoolean(selectionListElement, "nullable", true);
        try {
            Object bean = this.beanFactory.getBean(beanRef);
            if (bean != null && bean instanceof JavaSelectionList) {
                JavaSelectionList list = (JavaSelectionList)bean;
                list.setDatatype(datatype);
                list.setNullable(nullable);
                NamedNodeMap attrs = selectionListElement.getAttributes();
                int size = attrs.getLength();
                for (int i = 0; i < size; ++i) {
                    Node attr = attrs.item(i);
                    String name = attr.getNodeName();
                    list.setAttribute(name, attr.getNodeValue());
                }
                return list;
            }
            LOG.warn((Object)("Spring bean reference " + beanRef + " is not a " + JavaSelectionList.class.getName() + ", , returning empty selection list: " + DomHelper.getLocationObject(selectionListElement).getDescription()));
            return new StaticSelectionList(datatype);
        }
        catch (BeansException be) {
            LOG.warn((Object)("Spring bean reference " + beanRef + " does not exist, returning empty selection list: " + DomHelper.getLocationObject(selectionListElement).getDescription()));
            return new StaticSelectionList(datatype);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Got exception in build, re-throwing", (Throwable)e);
            }
            throw e;
        }
    }
}

