/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Union;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;

public class UnionJXPathBinding
extends ComposedJXPathBindingBase {
    private final String xpath;
    private final String widgetId;

    public UnionJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String widgetId, String xpath, JXPathBindingBase[] childBindings) {
        super(commonAtts, childBindings);
        this.widgetId = widgetId;
        this.xpath = xpath;
    }

    public String getXPath() {
        return this.xpath;
    }

    public String getId() {
        return this.widgetId;
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Widget widget = this.selectWidget(frmModel, this.widgetId);
        JXPathContext subContext = jxpc.getRelativeContext(jxpc.getPointer(this.xpath));
        if (!(widget instanceof Union)) {
            throw new RuntimeException("Binding: Expected Union widget, but received class: \"" + widget.getClass().getName() + "\".");
        }
        Union unionWidget = (Union)widget;
        JXPathBindingBase[] subBindings = this.getChildBindings();
        if (subBindings != null) {
            int size = subBindings.length;
            for (int i = 0; i < size; ++i) {
                subBindings[i].loadFormFromModel((Widget)unionWidget, (Object)subContext);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("done loading " + this));
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Union unionWidget = (Union)this.selectWidget(frmModel, this.widgetId);
        JXPathContext subContext = jxpc.getRelativeContext(jxpc.getPointer(this.xpath));
        JXPathBindingBase[] subBindings = this.getChildBindings();
        if (subBindings != null) {
            int size = subBindings.length;
            for (int i = 0; i < size; ++i) {
                subBindings[i].saveFormToModel((Widget)unionWidget, (Object)subContext);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("done saving " + this));
        }
    }

    public String toString() {
        return "UnionJXPathBinding [widget=" + this.widgetId + ", xpath=" + this.xpath + "]";
    }
}

