/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Iterator;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.RepeaterAdapter;
import org.apache.cocoon.forms.binding.RepeaterItem;
import org.apache.cocoon.forms.binding.RepeaterJXPathAdapter;
import org.apache.cocoon.forms.binding.RepeaterJXPathBinding;
import org.apache.cocoon.forms.binding.RepeaterJXPathCollection;
import org.apache.cocoon.forms.formmodel.EnhancedRepeater;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class EnhancedRepeaterJXPathBinding
extends RepeaterJXPathBinding {
    private String adapterClass;

    public EnhancedRepeaterJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String repeaterId, String repeaterPath, String rowPath, String rowPathForInsert, JXPathBindingBase[] childBindings, JXPathBindingBase insertBinding, JXPathBindingBase[] deleteBindings, JXPathBindingBase[] identityBindings, String adapterClass) {
        super(commonAtts, repeaterId, repeaterPath, rowPath, rowPathForInsert, childBindings, insertBinding, deleteBindings, identityBindings);
        this.adapterClass = adapterClass;
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        RepeaterAdapter adapter;
        Repeater repeater = (Repeater)this.selectWidget(frmModel, super.getId());
        if (!(repeater instanceof EnhancedRepeater)) {
            super.doLoad(frmModel, jxpc);
            return;
        }
        EnhancedRepeater rep = (EnhancedRepeater)repeater;
        if (this.adapterClass != null) {
            try {
                adapter = (RepeaterAdapter)Thread.currentThread().getContextClassLoader().loadClass(this.adapterClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate adapter class for advanced repeater binding", e);
            }
        } else {
            adapter = new RepeaterJXPathAdapter();
        }
        RepeaterJXPathCollection collection = new RepeaterJXPathCollection();
        collection.init(jxpc, super.getRowPath(), adapter);
        adapter.setBinding(this);
        adapter.setJXCollection(collection);
        rep.setCollection(collection);
        rep.doPageLoad();
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        RepeaterItem item;
        Repeater repeater = (Repeater)this.selectWidget(frmModel, super.getId());
        if (!(repeater instanceof EnhancedRepeater)) {
            super.doSave(frmModel, jxpc);
            return;
        }
        EnhancedRepeater rep = (EnhancedRepeater)repeater;
        rep.doPageSave();
        Pointer ptr = jxpc.getPointer(super.getRepeaterPath());
        JXPathContext repeaterContext = jxpc.getRelativeContext(ptr);
        RepeaterJXPathCollection collection = rep.getCollection();
        Iterator iter = collection.getUpdatedRows().iterator();
        while (iter.hasNext()) {
            item = (RepeaterItem)iter.next();
            this.getRowBinding().saveFormToModel((Widget)item.getRow(), item.getContext());
        }
        iter = collection.getDeletedRows().iterator();
        while (iter.hasNext()) {
            item = (RepeaterItem)iter.next();
            jxpc.removePath(item.getContext().createPath(".").asPath());
        }
        int indexCount = collection.getOriginalCollectionSize() - collection.getDeletedRows().size();
        Iterator iter2 = collection.getInsertedRows().iterator();
        while (iter2.hasNext()) {
            ++indexCount;
            RepeaterItem item2 = (RepeaterItem)iter2.next();
            if (this.getInsertRowBinding() != null) {
                this.getInsertRowBinding().saveFormToModel((Widget)item2.getRow(), repeaterContext);
            }
            Pointer newRowContextPointer = repeaterContext.createPath(super.getInsertRowPath() + "[" + indexCount + "]");
            JXPathContext newRowContext = repeaterContext.getRelativeContext(newRowContextPointer);
            super.getRowBinding().saveFormToModel((Widget)item2.getRow(), newRowContext);
        }
    }
}

