/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Collection;

public class TxnPutOperation
extends CollectionKeyBasedOperation {
    long recordId;
    Data value;
    transient long begin = -1L;

    public TxnPutOperation() {
    }

    public TxnPutOperation(CollectionProxyId proxyId, Data dataKey, Data value, long recordId) {
        super(proxyId, dataKey);
        this.recordId = recordId;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        CollectionContainer container = this.getOrCreateContainer();
        CollectionWrapper wrapper = container.getOrCreateCollectionWrapper(this.dataKey);
        this.response = true;
        if (wrapper.containsRecordId(this.recordId)) {
            this.response = false;
            return;
        }
        Collection<CollectionRecord> coll = wrapper.getCollection();
        CollectionRecord record = new CollectionRecord(this.recordId, this.isBinary() ? this.value : this.toObject(this.value));
        coll.add(record);
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        CollectionService service = (CollectionService)this.getService();
        service.getLocalMultiMapStatsImpl(this.proxyId).incrementPuts(elapsed);
        if (Boolean.TRUE.equals(this.response)) {
            this.publishEvent(EntryEventType.ADDED, this.dataKey, this.value);
        }
    }

    public long getRecordId() {
        return this.recordId;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public int getId() {
        return 33;
    }
}

