/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.operations.AddAllOperation;
import com.hazelcast.collection.operations.CollectionOperation;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.collection.operations.CompareAndRemoveOperation;
import com.hazelcast.collection.operations.ContainsAllOperation;
import com.hazelcast.collection.operations.ContainsOperation;
import com.hazelcast.collection.operations.CountOperation;
import com.hazelcast.collection.operations.GetAllOperation;
import com.hazelcast.collection.operations.GetOperation;
import com.hazelcast.collection.operations.IndexOfOperation;
import com.hazelcast.collection.operations.MultiMapOperationFactory;
import com.hazelcast.collection.operations.PutOperation;
import com.hazelcast.collection.operations.RemoveAllOperation;
import com.hazelcast.collection.operations.RemoveIndexOperation;
import com.hazelcast.collection.operations.RemoveOperation;
import com.hazelcast.collection.operations.SetOperation;
import com.hazelcast.concurrent.lock.proxy.LockProxySupport;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public abstract class MultiMapProxySupport
extends AbstractDistributedObject<CollectionService> {
    protected final MultiMapConfig config;
    protected final CollectionProxyId proxyId;
    protected final LockProxySupport lockSupport;

    protected MultiMapProxySupport(CollectionService service, NodeEngine nodeEngine, MultiMapConfig config, CollectionProxyId proxyId) {
        super(nodeEngine, service);
        this.config = config;
        this.proxyId = proxyId;
        this.lockSupport = new LockProxySupport(new DefaultObjectNamespace("hz:impl:collectionService", proxyId));
    }

    public <V> Collection<V> createNew() {
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
            return new HashSet(10);
        }
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
            return new LinkedList();
        }
        throw new IllegalArgumentException("No Matching CollectionProxyType!");
    }

    protected Boolean putInternal(Data dataKey, Data dataValue, int index) {
        try {
            PutOperation operation = new PutOperation(this.proxyId, dataKey, this.getThreadId(), dataValue, index);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected CollectionResponse getAllInternal(Data dataKey) {
        try {
            GetAllOperation operation = new GetAllOperation(this.proxyId, dataKey);
            return (CollectionResponse)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Boolean removeInternal(Data dataKey, Data dataValue) {
        try {
            RemoveOperation operation = new RemoveOperation(this.proxyId, dataKey, this.getThreadId(), dataValue);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected CollectionResponse removeInternal(Data dataKey) {
        try {
            RemoveAllOperation operation = new RemoveAllOperation(this.proxyId, dataKey, this.getThreadId());
            return (CollectionResponse)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Set<Data> localKeySetInternal() {
        return ((CollectionService)this.getService()).localKeySet(this.proxyId);
    }

    protected Set<Data> keySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:collectionService", new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.KEY_SET));
            HashSet<Data> keySet = new HashSet<Data>();
            for (Object result : results.values()) {
                CollectionResponse response;
                if (result == null || (response = (CollectionResponse)nodeEngine.toObject(result)).getCollection() == null) continue;
                keySet.addAll(response.getCollection());
            }
            return keySet;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Map valuesInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:collectionService", new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.VALUES));
            return results;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Map entrySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:collectionService", new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.ENTRY_SET));
            return results;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected boolean containsInternal(Data key, Data value) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:collectionService", new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.CONTAINS, key, value));
            for (Object obj : results.values()) {
                Boolean result;
                if (obj == null || !(result = (Boolean)nodeEngine.toObject(obj)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public int size() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:collectionService", new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.SIZE));
            int size = 0;
            for (Object obj : results.values()) {
                if (obj == null) continue;
                Integer result = (Integer)nodeEngine.toObject(obj);
                size += result.intValue();
            }
            return size;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public void clear() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:collectionService", new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.CLEAR));
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Integer countInternal(Data dataKey) {
        try {
            CountOperation operation = new CountOperation(this.proxyId, dataKey);
            return (Integer)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Object getInternal(Data dataKey, int index) {
        try {
            GetOperation operation = new GetOperation(this.proxyId, dataKey, index);
            return this.invokeData(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Boolean containsInternalList(Data dataKey, Data dataValue) {
        try {
            ContainsOperation operation = new ContainsOperation(this.proxyId, dataKey, dataValue);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Boolean containsAllInternal(Data dataKey, Set<Data> dataSet) {
        try {
            ContainsAllOperation operation = new ContainsAllOperation(this.proxyId, dataKey, dataSet);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Object setInternal(Data dataKey, int index, Data dataValue) {
        try {
            SetOperation operation = new SetOperation(this.proxyId, dataKey, this.getThreadId(), index, dataValue);
            return this.invokeData(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Object removeInternal(Data dataKey, int index) {
        try {
            RemoveIndexOperation operation = new RemoveIndexOperation(this.proxyId, dataKey, this.getThreadId(), index);
            return this.invokeData(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Integer indexOfInternal(Data dataKey, Data value, boolean last) {
        try {
            IndexOfOperation operation = new IndexOfOperation(this.proxyId, dataKey, value, last);
            return (Integer)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Boolean addAllInternal(Data dataKey, List<Data> dataList, int index) {
        try {
            AddAllOperation operation = new AddAllOperation(this.proxyId, dataKey, this.getThreadId(), dataList, index);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Boolean compareAndRemoveInternal(Data dataKey, List<Data> dataList, boolean retain) {
        try {
            CompareAndRemoveOperation operation = new CompareAndRemoveOperation(this.proxyId, dataKey, this.getThreadId(), dataList, retain);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public Object getId() {
        return this.proxyId;
    }

    @Override
    public String getName() {
        return this.proxyId.getName();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:collectionService";
    }

    private <T> T invoke(Operation operation, Data dataKey) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Object o;
            int partitionId = nodeEngine.getPartitionService().getPartitionId(dataKey);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:collectionService", operation, partitionId).build();
            if (this.config.isStatisticsEnabled()) {
                long time = System.currentTimeMillis();
                Future f = invocation.invoke();
                o = f.get();
                if (operation instanceof PutOperation) {
                    ((CollectionService)this.getService()).getLocalMultiMapStatsImpl(this.proxyId).incrementPuts(System.currentTimeMillis() - time);
                } else if (operation instanceof RemoveOperation || operation instanceof RemoveAllOperation) {
                    ((CollectionService)this.getService()).getLocalMultiMapStatsImpl(this.proxyId).incrementRemoves(System.currentTimeMillis() - time);
                } else if (operation instanceof GetAllOperation) {
                    ((CollectionService)this.getService()).getLocalMultiMapStatsImpl(this.proxyId).incrementGets(System.currentTimeMillis() - time);
                }
            } else {
                Future f = invocation.invoke();
                o = f.get();
            }
            return nodeEngine.toObject(o);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    private Object invokeData(CollectionOperation operation, Data dataKey) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(dataKey);
            Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
            Future f = inv.invoke();
            return nodeEngine.toObject(f.get());
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    private int getThreadId() {
        return ThreadUtil.getThreadId();
    }
}

