/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class JoinCheckOperation
extends AbstractOperation
implements JoinOperation {
    private JoinRequest joinRequest;
    private transient JoinRequest response;

    public JoinCheckOperation() {
    }

    public JoinCheckOperation(JoinRequest joinRequest) {
        this.joinRequest = joinRequest;
    }

    @Override
    public void run() {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Node node = nodeEngine.getNode();
        boolean ok = false;
        if (this.joinRequest != null && node.joined() && node.isActive()) {
            try {
                ok = service.validateJoinMessage(this.joinRequest);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (ok) {
            this.response = node.createJoinRequest();
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.joinRequest = new JoinRequest();
        this.joinRequest.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.joinRequest.writeData(out);
    }
}

