/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import org.compass.core.Property;
import org.compass.core.accessor.AccessorUtils;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.DelegateConverter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.internal.InternalResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.util.ClassUtils;

public abstract class MappingProcessorUtils {
    public static void lookupConverter(ConverterLookup converterLookup, Mapping mapping) {
        MappingProcessorUtils.lookupConverter(converterLookup, mapping, true);
    }

    public static void lookupConverter(ConverterLookup converterLookup, Mapping mapping, boolean forceConverter) {
        if (mapping.getConverter() == null) {
            if (mapping.getConverterName() != null) {
                String converterName = mapping.getConverterName();
                mapping.setConverter(converterLookup.lookupConverter(converterName));
                if (mapping.getConverter() == null && forceConverter) {
                    throw new ConfigurationException("Failed to find converter [" + converterName + "] for mapping " + "[" + mapping.getName() + "]");
                }
            } else {
                mapping.setConverter(converterLookup.lookupConverter(mapping.getClass()));
                if (mapping.getConverter() == null && forceConverter) {
                    throw new ConfigurationException("Failed to find converter for class [" + mapping.getClass() + "]" + " for mapping [" + mapping.getName() + "]");
                }
            }
        }
    }

    public static void lookupConverter(ConverterLookup converterLookup, ClassPropertyMetaDataMapping mdMapping, ClassPropertyMapping classPropertyMapping) {
        if (mdMapping.getConverter() == null) {
            if (mdMapping.getConverterName() != null) {
                String converterName = mdMapping.getConverterName();
                mdMapping.setConverter(converterLookup.lookupConverter(converterName));
                if (mdMapping.getConverter() == null) {
                    throw new ConfigurationException("Failed to find converter [" + converterName + "] for property " + "[" + classPropertyMapping.getName() + "] and alias [" + classPropertyMapping.getDefinedInAlias() + "]");
                }
            } else {
                Converter converter = MappingProcessorUtils.resolveConverterByClass(classPropertyMapping, converterLookup);
                mdMapping.setConverter(converter);
            }
        } else if (mdMapping.getConverter() instanceof DelegateConverter) {
            Converter converter = MappingProcessorUtils.resolveConverterByClass(classPropertyMapping, converterLookup);
            ((DelegateConverter)mdMapping.getConverter()).setDelegatedConverter(converter);
        }
    }

    public static void addInternalId(CompassSettings settings, ConverterLookup converterLookup, ClassPropertyMapping classPropertyMapping, boolean mustBeUntokenized) throws MappingException {
        Property.Index index;
        ClassPropertyMetaDataMapping internalIdMapping = new ClassPropertyMetaDataMapping();
        internalIdMapping.setInternal(true);
        internalIdMapping.setName(classPropertyMapping.getName());
        internalIdMapping.setStore(Property.Store.YES);
        internalIdMapping.setOmitNorms(true);
        if (mustBeUntokenized) {
            index = Property.Index.UN_TOKENIZED;
        } else {
            index = classPropertyMapping.getManagedIdIndex();
            if (index == null) {
                String indexSetting = settings.getSetting("compass.osem.managedId.index", "tokenized");
                index = Property.Index.fromString(indexSetting);
            }
        }
        internalIdMapping.setIndex(index);
        internalIdMapping.setBoost(1.0f);
        internalIdMapping.setGetter(classPropertyMapping.getGetter());
        internalIdMapping.setSetter(classPropertyMapping.getSetter());
        internalIdMapping.setConverter(classPropertyMapping.getManagedIdConverter());
        internalIdMapping.setConverterName(classPropertyMapping.getManagedIdConverterName());
        MappingProcessorUtils.process(internalIdMapping, classPropertyMapping, converterLookup);
        int propertyIndex = classPropertyMapping.addMapping(internalIdMapping);
        classPropertyMapping.setIdPropertyIndex(propertyIndex);
    }

    public static void process(ClassPropertyMetaDataMapping mdMapping, ClassPropertyMapping classPropertyMapping, ConverterLookup converterLookup) throws MappingException {
        MappingProcessorUtils.lookupConverter(converterLookup, mdMapping, classPropertyMapping);
        mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
        if (mdMapping.isInternal()) {
            mdMapping.setPath(classPropertyMapping.getPath().hintStatic());
        } else {
            mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
        }
    }

    private static Converter resolveConverterByClass(ClassPropertyMapping classPropertyMapping, ConverterLookup converterLookup) {
        Converter converter;
        String className = classPropertyMapping.getClassName();
        Class clazz = null;
        try {
            if (className != null) {
                clazz = ClassUtils.forName(className, converterLookup.getSettings().getClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Failed to find class [" + className + "]", e);
        }
        if (clazz == null) {
            clazz = AccessorUtils.getCollectionParameter(classPropertyMapping.getGetter());
        }
        if (clazz == null) {
            clazz = classPropertyMapping.getGetter().getReturnType();
            converter = converterLookup.lookupConverter(clazz);
            if (converter == null && clazz.isArray()) {
                clazz = clazz.getComponentType();
                converter = converterLookup.lookupConverter(clazz);
            }
        } else {
            converter = converterLookup.lookupConverter(clazz);
        }
        if (converter == null) {
            throw new MappingException("No converter defined for type [" + classPropertyMapping.getGetter().getReturnType().getName() + "]");
        }
        return converter;
    }

    public static void applyResourcePropertySettings(ResourcePropertyMapping mapping, CompassSettings settings) {
        InternalResourcePropertyMapping intMapping = (InternalResourcePropertyMapping)mapping;
        ResourcePropertyConverter converter = null;
        if (mapping.getConverter() instanceof ResourcePropertyConverter) {
            converter = (ResourcePropertyConverter)mapping.getConverter();
        }
        if (intMapping.getIndex() == null) {
            if (converter != null) {
                intMapping.setIndex(converter.suggestIndex());
            }
            if (intMapping.getIndex() == null) {
                intMapping.setIndex(Property.Index.fromString(settings.getSetting("comapss.mapping.globalIndex", Property.Index.TOKENIZED.toString())));
            }
        }
        if (intMapping.getStore() == null) {
            if (converter != null) {
                intMapping.setStore(converter.suggestStore());
            }
            if (intMapping.getStore() == null) {
                intMapping.setStore(Property.Store.fromString(settings.getSetting("compass.mapping.globalStore", Property.Store.YES.toString())));
            }
        }
        if (intMapping.getTermVector() == null) {
            if (converter != null) {
                intMapping.setTermVector(converter.suggestTermVector());
            }
            if (intMapping.getTermVector() == null) {
                intMapping.setTermVector(Property.TermVector.fromString(settings.getSetting("compass.mapping.globalTermVector", Property.TermVector.NO.toString())));
            }
        }
        if (intMapping.isOmitNorms() == null) {
            if (converter != null) {
                intMapping.setOmitNorms(intMapping.isOmitNorms());
            }
            if (intMapping.isOmitNorms() == null) {
                intMapping.setOmitNorms(settings.getSettingAsBoolean("compass.mapping.globalOmitNorms", false));
            }
        }
    }
}

