/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.CachedElement;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.AbstractEuGridPmaNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class LazyEuGridPmaNamespacesStore
extends AbstractEuGridPmaNamespacesStore {
    private Map<String, CachedElement<Map<String, List<NamespacePolicy>>>> policiesByHash;
    private Map<String, CachedElement<Map<String, List<NamespacePolicy>>>> policiesByName = new WeakHashMap<String, CachedElement<Map<String, List<NamespacePolicy>>>>(150);
    protected final String directory;
    protected final long updateInterval;

    public LazyEuGridPmaNamespacesStore(ObserversHandler observers, boolean openssl1Mode, String directory, long updateInterval) {
        super(observers, openssl1Mode);
        this.policiesByHash = new WeakHashMap<String, CachedElement<Map<String, List<NamespacePolicy>>>>(150);
        this.directory = directory;
        this.updateInterval = updateInterval;
    }

    @Override
    public void setPolicies(Collection<String> locations) {
    }

    @Override
    protected List<NamespacePolicy> getPoliciesByIssuerHash(String definedForHash, String issuerHash) {
        String path = this.directory + File.separator + definedForHash + ".namespaces";
        return this.getCachedPolicies(this.policiesByHash, definedForHash, issuerHash, path, this.updateInterval);
    }

    @Override
    protected List<NamespacePolicy> getPoliciesByIssuerDn(String definedForHash, String issuerDn) {
        String path = this.directory + File.separator + definedForHash + ".namespaces";
        return this.getCachedPolicies(this.policiesByName, definedForHash, issuerDn, path, this.updateInterval);
    }
}

