/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.util.DurationFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActiveCompactionHelper {
    private static final Logger log = LoggerFactory.getLogger(ActiveCompactionHelper.class);

    ActiveCompactionHelper() {
    }

    private static String maxDecimal(double count) {
        if (count < 9.995) {
            return String.format("%.2f", count);
        }
        if (count < 99.95) {
            return String.format("%.1f", count);
        }
        return String.format("%.0f", count);
    }

    private static String shortenCount(long count) {
        if (count < 1000L) {
            return "" + count;
        }
        if (count < 1000000L) {
            return ActiveCompactionHelper.maxDecimal((double)count / 1000.0) + "K";
        }
        if (count < 1000000000L) {
            return ActiveCompactionHelper.maxDecimal((double)count / 1000000.0) + "M";
        }
        return ActiveCompactionHelper.maxDecimal((double)count / 1.0E9) + "B";
    }

    private static String formatActiveCompactionLine(ActiveCompaction ac) {
        String hostSuffix;
        String output = ac.getOutputFile();
        int index = output.indexOf("tables");
        if (index > 0) {
            output = output.substring(index + 6);
        }
        ArrayList<CallSite> iterList = new ArrayList<CallSite>();
        HashMap<String, Map> iterOpts = new HashMap<String, Map>();
        for (IteratorSetting is : ac.getIterators()) {
            iterList.add((CallSite)((Object)(is.getName() + "=" + is.getPriority() + "," + is.getIteratorClass())));
            iterOpts.put(is.getName(), is.getOptions());
        }
        switch (ac.getHost().getType()) {
            case TSERVER: {
                hostSuffix = "";
                break;
            }
            case COMPACTOR: {
                hostSuffix = " (ext)";
                break;
            }
            default: {
                hostSuffix = ac.getHost().getType().name();
            }
        }
        String host = ac.getHost().getAddress() + ":" + ac.getHost().getPort() + hostSuffix;
        try {
            DurationFormat dur = new DurationFormat(ac.getAge(), "");
            return String.format("%21s | %9s | %5s | %6s | %5s | %5s | %15s | %-40s | %5s | %35s | %9s | %s", host, dur, ac.getType(), ac.getReason(), ActiveCompactionHelper.shortenCount(ac.getEntriesRead()), ActiveCompactionHelper.shortenCount(ac.getEntriesWritten()), ac.getTable(), ac.getTablet(), ac.getInputFiles().size(), output, iterList, iterOpts);
        }
        catch (TableNotFoundException e) {
            return "ERROR " + e.getMessage();
        }
    }

    public static Stream<String> appendHeader(Stream<String> stream) {
        Stream<String> header = Stream.of(String.format(" %-21s| %-9s | %-5s | %-6s | %-5s | %-5s | %-15s | %-40s | %-5s | %-35s | %-9s | %s", "SERVER", "AGE", "TYPE", "REASON", "READ", "WROTE", "TABLE", "TABLET", "INPUT", "OUTPUT", "ITERATORS", "ITERATOR OPTIONS"));
        return Stream.concat(header, stream);
    }

    public static Stream<String> activeCompactionsForServer(String tserver, InstanceOperations instanceOps) {
        ArrayList<Object> compactions = new ArrayList<Object>();
        try {
            ArrayList acl = new ArrayList(instanceOps.getActiveCompactions(tserver));
            acl.sort((o1, o2) -> (int)(o2.getAge() - o1.getAge()));
            for (ActiveCompaction ac : acl) {
                compactions.add(ActiveCompactionHelper.formatActiveCompactionLine(ac));
            }
        }
        catch (Exception e) {
            log.debug("Failed to list active compactions for server {}", (Object)tserver, (Object)e);
            compactions.add(tserver + " ERROR " + e.getMessage());
        }
        return compactions.stream();
    }

    public static Stream<String> stream(InstanceOperations instanceOps) {
        List activeCompactions;
        try {
            activeCompactions = instanceOps.getActiveCompactions();
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            return Stream.of("ERROR " + e.getMessage());
        }
        Comparator<ActiveCompaction> comparator = Comparator.comparing(ac -> ac.getHost().getAddress());
        comparator = comparator.thenComparing(ac -> ac.getHost().getPort()).thenComparing((o1, o2) -> (int)(o2.getAge() - o1.getAge()));
        activeCompactions.sort(comparator);
        return activeCompactions.stream().map(ac -> ActiveCompactionHelper.formatActiveCompactionLine(ac));
    }
}

